import type {
    IRouteLocationInterface,
    IRouteParamsCursorInterface,
    IRouteParamsInterface,
    IRouteRequestInterface,
    IRouteResponseCursorMetaDataInterface,
    IRouteResponseInterface,
} from "@devowl-wp/api";
import { ERouteHttpVerb } from "@devowl-wp/api";

import type { IMedia } from "../../entity/media.js";

const routeLocationMediaGet: IRouteLocationInterface = {
    path: "/media",
    method: ERouteHttpVerb.GET,
};

interface IRouteRequestMediaGet extends IRouteRequestInterface {}

interface IRouteParamsMediaGet extends IRouteParamsInterface, IRouteParamsCursorInterface {
    search?: string;
    limit: number;
    cursor: string; // like: id:23494
}

interface IRouteResponseMediaGet extends IRouteResponseInterface, IRouteResponseCursorMetaDataInterface {
    data: IMedia[];
}

export { routeLocationMediaGet, type IRouteRequestMediaGet, type IRouteParamsMediaGet, type IRouteResponseMediaGet };
