import type {
    IRouteLocationInterface,
    IRouteParamsInterface,
    IRouteRequestInterface,
    IRouteResponseInterface,
} from "@devowl-wp/api";
import { ERouteHttpVerb } from "@devowl-wp/api";

const routeLocationMediaPost: IRouteLocationInterface = {
    path: "/media",
    method: ERouteHttpVerb.POST,
};

interface IRouteRequestMediaPost<File> extends IRouteRequestInterface {
    files: File[];
}

interface IRouteParamsMediaPost extends IRouteParamsInterface {}

interface IRouteResponseMediaPost extends IRouteResponseInterface {}

export {
    routeLocationMediaPost,
    type IRouteRequestMediaPost,
    type IRouteParamsMediaPost,
    type IRouteResponseMediaPost,
};
