import type {
    IRouteLocationInterface,
    IRouteParamsInterface,
    IRouteRequestInterface,
    IRouteResponseInterface,
    TranslatablesOptions,
} from "@devowl-wp/api";
import { ERouteHttpVerb } from "@devowl-wp/api";

interface IRouteParamsEntityMetaDataGet extends IRouteParamsInterface {
    entity: string;
}

interface IRouteRequestEntityMetaDataGet extends IRouteRequestInterface {
    // Add any specific request properties if needed
}

interface IRouteResponseEntityMetaDataGet extends IRouteResponseInterface {
    translatableOptions: TranslatablesOptions[];
}

const routeLocationEntityMetDataGet: IRouteLocationInterface = {
    path: "/metadata/entity",
    method: ERouteHttpVerb.GET,
};

export {
    type IRouteParamsEntityMetaDataGet,
    type IRouteRequestEntityMetaDataGet,
    type IRouteResponseEntityMetaDataGet,
    routeLocationEntityMetDataGet,
};
