import type {
    IRouteLocationInterface,
    IRouteParamsInterface,
    IRouteRequestInterface,
    IRouteResponseInterface,
} from "@devowl-wp/api";
import { ERouteHttpVerb } from "@devowl-wp/api";

import type { IPreReleaseClient } from "../../entity/template/pre-release-client.js";

const routeLocationPreReleaseClientPut: IRouteLocationInterface = {
    path: "/pre-release-client",
    method: ERouteHttpVerb.PUT,
};

interface IRouteRequestPreReleaseClientPut extends IRouteRequestInterface {
    preReleaseClient: IPreReleaseClient;
}

interface IRouteParamsPreReleaseClientPut extends IRouteParamsInterface {}

interface IRouteResponsePreReleaseClientPut extends IRouteResponseInterface {
    preReleaseClient: IPreReleaseClient;
}

export {
    routeLocationPreReleaseClientPut,
    type IRouteRequestPreReleaseClientPut,
    type IRouteParamsPreReleaseClientPut,
    type IRouteResponsePreReleaseClientPut,
};
