import type {
    IRouteLocationInterface,
    IRouteParamsInterface,
    IRouteRequestInterface,
    IRouteResponseInterface,
} from "@devowl-wp/api";
import { ERouteHttpVerb } from "@devowl-wp/api";

import type { IPreReleaseClient } from "../../entity/template/pre-release-client.js";

const routeLocationPreReleaseClientsGet: IRouteLocationInterface = {
    path: "/pre-release-clients",
    method: ERouteHttpVerb.GET,
};

interface IRouteRequestPreReleaseClientsGet extends IRouteRequestInterface {}

interface IRouteParamsPreReleaseClientsGet extends IRouteParamsInterface {
    enabled?: boolean;
    clientUuid?: string;
}

interface IRouteResponsePreReleaseClientsGet extends IRouteResponseInterface {
    preReleaseClients: IPreReleaseClient[];
}

export {
    routeLocationPreReleaseClientsGet,
    type IRouteRequestPreReleaseClientsGet,
    type IRouteParamsPreReleaseClientsGet,
    type IRouteResponsePreReleaseClientsGet,
};
