import type {
    IRouteLocationInterface,
    IRouteParamsInterface,
    IRouteRequestInterface,
    IRouteResponseInterface,
} from "@devowl-wp/api";
import { ERouteHttpVerb } from "@devowl-wp/api";

const routeLocationDependenciesGet: IRouteLocationInterface = {
    path: "/release/dependencies",
    method: ERouteHttpVerb.GET,
};

interface IRouteRequestDependenciesGet extends IRouteRequestInterface {}

interface IRouteParamsDependenciesGet extends IRouteParamsInterface {
    serviceIds?: string; // comma separated
    contentBlockerIds?: string; // comma separated
}

interface IRouteResponseDependenciesGet extends IRouteResponseInterface {
    serviceIds?: string[];
    contentBlockerIds?: string[];
}

export {
    type IRouteParamsDependenciesGet,
    type IRouteRequestDependenciesGet,
    type IRouteResponseDependenciesGet,
    routeLocationDependenciesGet,
};
