import type {
    IRouteLocationInterface,
    IRouteParamsInterface,
    IRouteRequestInterface,
    IRouteResponseInterface,
} from "@devowl-wp/api";
import { ERouteHttpVerb } from "@devowl-wp/api";

import type { IContentBlockerTemplate } from "../../entity/template/content-blocker/content-blocker.js";
import type { IServiceTemplate } from "../../entity/template/service/service.js";

const routeLocationReleaseGet: IRouteLocationInterface = {
    path: "/release",
    method: ERouteHttpVerb.GET,
};

interface IRouteRequestReleaseGet extends IRouteRequestInterface {}

interface IRouteParamsReleaseGet extends IRouteParamsInterface {
    id?: number;
}

interface IRouteResponseReleaseGet extends IRouteResponseInterface {
    current: {
        serviceTemplates?: IServiceTemplate[];
        contentBlockerTemplates?: IContentBlockerTemplate[];
    };
    prev: {
        serviceTemplates?: IServiceTemplate[];
        contentBlockerTemplates?: IContentBlockerTemplate[];
    };
}

export {
    routeLocationReleaseGet,
    type IRouteRequestReleaseGet,
    type IRouteParamsReleaseGet,
    type IRouteResponseReleaseGet,
};
