import type { IRouteLocationInterface, IRouteParamsInterface, IRouteRequestInterface } from "@devowl-wp/api";
import { ERouteHttpVerb } from "@devowl-wp/api";

import type { IRelease } from "../../entity/template/release.js";

const routeLocationReleasePost: IRouteLocationInterface = {
    path: "/release",
    method: ERouteHttpVerb.POST,
};

interface IRouteRequestReleasePost extends IRouteRequestInterface {
    serviceIds?: number[];
    contentBlockerIds?: number[];
    disablePreReleaseClients?: boolean;
}

interface IRouteParamsReleasePost extends IRouteParamsInterface {}

type IRouteResponseReleasePost = IRelease;

export {
    routeLocationReleasePost,
    type IRouteRequestReleasePost,
    type IRouteParamsReleasePost,
    type IRouteResponseReleasePost,
};
