import type {
    IRouteLocationInterface,
    IRouteParamsInterface,
    IRouteRequestInterface,
    IRouteResponseInterface,
} from "@devowl-wp/api";
import { ERouteHttpVerb } from "@devowl-wp/api";

import type { IRelease } from "../../entity/template/release.js";

const routeLocationReleasesGet: IRouteLocationInterface = {
    path: "/releases",
    method: ERouteHttpVerb.GET,
};

interface IRouteRequestReleasesGet extends IRouteRequestInterface {}

interface IRouteParamsReleasesGet extends IRouteParamsInterface {}

interface IRouteResponseReleasesGet extends IRouteResponseInterface {
    releases: IRelease[];
}

export {
    routeLocationReleasesGet,
    type IRouteRequestReleasesGet,
    type IRouteParamsReleasesGet,
    type IRouteResponseReleasesGet,
};
