import type {
    IRouteLocationInterface,
    IRouteParamsInterface,
    IRouteRequestInterface,
    IRouteResponseInterface,
} from "@devowl-wp/api";
import { ERouteHttpVerb } from "@devowl-wp/api";

import type { ETcfGvlLanguage, ITcfGvlPurposes } from "../../../../service/tcf.js";

const routeLocationTcfGvlV2PurposesGet: IRouteLocationInterface = {
    path: "/tcf/gvl/v2/purposes.json",
    method: ERouteHttpVerb.GET,
};

interface IRouteRequestTcfGvlV2PurposesGet extends IRouteRequestInterface {}

interface IRouteParamsTcfGvlV2PurposesGet extends IRouteParamsInterface {
    language: ETcfGvlLanguage;
}

interface IRouteResponseTcfGvlV2PurposesGet extends IRouteResponseInterface, ITcfGvlPurposes {}

export {
    routeLocationTcfGvlV2PurposesGet,
    type IRouteRequestTcfGvlV2PurposesGet,
    type IRouteParamsTcfGvlV2PurposesGet,
    type IRouteResponseTcfGvlV2PurposesGet,
};
