import type {
    IRouteLocationInterface,
    IRouteParamsInterface,
    IRouteRequestInterface,
    IRouteResponseInterface,
} from "@devowl-wp/api";
import { ERouteHttpVerb } from "@devowl-wp/api";

import type { ITcfGvlVendorListComposed } from "../../../../service/tcf.js";

const routeLocationTcfGvlV2VendorListGet: IRouteLocationInterface = {
    path: "/tcf/gvl/v2/vendor-list.json",
    method: ERouteHttpVerb.GET,
};

interface IRouteRequestTcfGvlV2VendorListGet extends IRouteRequestInterface {}

interface IRouteParamsTcfGvlV2VendorListGet extends IRouteParamsInterface {}

interface IRouteResponseTcfGvlV2VendorListGet extends IRouteResponseInterface, ITcfGvlVendorListComposed {}

export {
    routeLocationTcfGvlV2VendorListGet,
    type IRouteRequestTcfGvlV2VendorListGet,
    type IRouteParamsTcfGvlV2VendorListGet,
    type IRouteResponseTcfGvlV2VendorListGet,
};
