import type {
    IRouteLocationInterface,
    IRouteParamsInterface,
    IRouteRequestInterface,
    IRouteResponseInterface,
} from "@devowl-wp/api";
import { ERouteHttpVerb } from "@devowl-wp/api";

import type { ETcfGvlLanguage, ITcfGvlPurposes } from "../../../../service/tcf.js";

const routeLocationTcfGvlV3PurposesGet: IRouteLocationInterface = {
    path: "/tcf/gvl/v3/purposes.json",
    method: ERouteHttpVerb.GET,
};

interface IRouteRequestTcfGvlV3PurposesGet extends IRouteRequestInterface {}

interface IRouteParamsTcfGvlV3PurposesGet extends IRouteParamsInterface {
    language: ETcfGvlLanguage;
}

interface IRouteResponseTcfGvlV3PurposesGet extends IRouteResponseInterface, ITcfGvlPurposes {}

export {
    routeLocationTcfGvlV3PurposesGet,
    type IRouteRequestTcfGvlV3PurposesGet,
    type IRouteParamsTcfGvlV3PurposesGet,
    type IRouteResponseTcfGvlV3PurposesGet,
};
