import type {
    IRouteLocationInterface,
    IRouteParamsInterface,
    IRouteRequestInterface,
    IRouteResponseInterface,
} from "@devowl-wp/api";
import { ERouteHttpVerb } from "@devowl-wp/api";

import type { ITcfGvlVendorListComposed } from "../../../../service/tcf.js";

const routeLocationTcfGvlV3VendorListGet: IRouteLocationInterface = {
    path: "/tcf/gvl/v3/vendor-list.json",
    method: ERouteHttpVerb.GET,
};

interface IRouteRequestTcfGvlV3VendorListGet extends IRouteRequestInterface {}

interface IRouteParamsTcfGvlV3VendorListGet extends IRouteParamsInterface {}

interface IRouteResponseTcfGvlV3VendorListGet extends IRouteResponseInterface, ITcfGvlVendorListComposed {}

export {
    routeLocationTcfGvlV3VendorListGet,
    type IRouteRequestTcfGvlV3VendorListGet,
    type IRouteParamsTcfGvlV3VendorListGet,
    type IRouteResponseTcfGvlV3VendorListGet,
};
