import type { IRouteLocationInterface, IRouteParamsInterface, IRouteRequestInterface } from "@devowl-wp/api";
import { ERouteHttpVerb } from "@devowl-wp/api";

import type { IContentBlockerTemplate } from "../../../entity/template/content-blocker/content-blocker.js";

const routeLocationContentBlockerGet: IRouteLocationInterface = {
    path: "/template/content-blocker",
    method: ERouteHttpVerb.GET,
};

interface IRouteRequestContentBlockerGet extends IRouteRequestInterface {}

interface IRouteParamsContentBlockerGet extends IRouteParamsInterface {
    /**
     * Will deliver the exact template with given id.
     */
    id?: string;
    /**
     * Will search for the latest template matching this identifier.
     */
    identifier?: string;
}

type IRouteResponseContentBlockerGet = IContentBlockerTemplate;

export {
    routeLocationContentBlockerGet,
    type IRouteRequestContentBlockerGet,
    type IRouteParamsContentBlockerGet,
    type IRouteResponseContentBlockerGet,
};
