import type { IRouteLocationInterface, IRouteParamsInterface, IRouteRequestInterface } from "@devowl-wp/api";
import { ERouteHttpVerb } from "@devowl-wp/api";

import type { IContentBlockerTemplate } from "../../../entity/template/content-blocker/content-blocker.js";

const routeLocationContentBlockerPost: IRouteLocationInterface = {
    path: "/template/content-blocker",
    method: ERouteHttpVerb.POST,
};

interface IRouteRequestContentBlockerPost extends IRouteRequestInterface {
    contentBlockerTemplate: IContentBlockerTemplate;
}

interface IRouteParamsContentBlockerPost extends IRouteParamsInterface {
    /**
     * Skippable names for validation (comma separated list)
     *
     * @see https://app.clickup.com/t/2kav8bg
     */
    skipValidationNames: string;
    /**
     * Allow specific actions on admin imports.
     *
     * @see https://app.clickup.com/t/863gcdu2z
     */
    isImport: boolean;
}

type IRouteResponseContentBlockerPost = IContentBlockerTemplate;

export {
    routeLocationContentBlockerPost,
    type IRouteRequestContentBlockerPost,
    type IRouteParamsContentBlockerPost,
    type IRouteResponseContentBlockerPost,
};
