import type {
    IRouteLocationInterface,
    IRouteParamsCursorInterface,
    IRouteParamsInterface,
    IRouteRequestInterface,
    IRouteResponseInterface,
} from "@devowl-wp/api";
import { ERouteHttpVerb } from "@devowl-wp/api";

import type { IContentBlockerTemplateClientResponse } from "../../../entity/template/content-blocker/content-blocker.js";
import type { IResponseMetadata } from "../response-meta.js";

const routeLocationContentBlockersGet: IRouteLocationInterface = {
    path: "/template/content-blockers",
    method: ERouteHttpVerb.GET,
};

interface IRouteRequestBodyContentBlockersGet extends IRouteRequestInterface {}

interface IRouteParamsContentBlockersGet extends IRouteParamsCursorInterface, IRouteParamsInterface {
    cursor: string; // example: id:1
    clientUuid: string;
    language: string;
    licenseKey: string;
    limit: number;
    minRequiredRcbVersion: string;
    noCache?: boolean;
    allowAsyncCacheCalculation?: boolean;
    includeExampleEmbedCodes?: boolean;
}

interface IRouteResponseContentBlockersGet extends IRouteResponseInterface {
    data: IContentBlockerTemplateClientResponse[];
    responseMetadata: IResponseMetadata;
}

export {
    routeLocationContentBlockersGet,
    type IRouteRequestBodyContentBlockersGet,
    type IRouteParamsContentBlockersGet,
    type IRouteResponseContentBlockersGet,
};
