import type {
    IRouteLocationInterface,
    IRouteParamsInterface,
    IRouteRequestInterface,
    IRouteResponseInterface,
} from "@devowl-wp/api";
import { ERouteHttpVerb } from "@devowl-wp/api";

import type { IServiceTemplate } from "../../../../entity/template/service/service.js";

const routeLocationContentBlockerFunctionToggleFavouritePut: IRouteLocationInterface = {
    path: "/template/content-blocker/functions/toggleFavourite",
    method: ERouteHttpVerb.PUT,
};

interface IRouteRequestContentBlockerFunctionToggleFavouritePut extends IRouteRequestInterface {
    id: string;
}

interface IRouteParamsContentBlockerFunctionToggleFavouritePut extends IRouteParamsInterface {}

interface IRouteResponseContentBlockerFunctionToggleFavouritePut extends IRouteResponseInterface {
    templateId: string;
    isFavourite: boolean;
    connectedTemplates: IServiceTemplate[];
}

export {
    type IRouteParamsContentBlockerFunctionToggleFavouritePut,
    type IRouteRequestContentBlockerFunctionToggleFavouritePut,
    type IRouteResponseContentBlockerFunctionToggleFavouritePut,
    routeLocationContentBlockerFunctionToggleFavouritePut,
};
