import type {
    IRouteLocationInterface,
    IRouteParamsInterface,
    IRouteRequestInterface,
    IRouteResponseInterface,
} from "@devowl-wp/api";
import { ERouteHttpVerb } from "@devowl-wp/api";

import type { StatisticsEntity } from "../../../../entity/statistics/statistics.js";

const routeLocationContentBlockerStatisticsGet: IRouteLocationInterface = {
    path: "/template/content-blockers/statistics",
    method: ERouteHttpVerb.GET,
};

interface IRouteRequestBodyContentBlockerStatisticsGet extends IRouteRequestInterface {}

interface IRouteParamsContentBlockerStatisticsGet extends IRouteParamsInterface {
    favouritesOnly?: boolean;
}

interface IRouteResponseContentBlockerStatisticsGet extends IRouteResponseInterface {
    statistics: {
        contentBlocker: StatisticsEntity;
    };
}

export {
    type IRouteParamsContentBlockerStatisticsGet,
    type IRouteRequestBodyContentBlockerStatisticsGet,
    type IRouteResponseContentBlockerStatisticsGet,
    routeLocationContentBlockerStatisticsGet,
};
