interface IResponseMetadata {
    cursor?: string;
    nextCursor?: string;
    dataCount?: number;
    cacheInfo?: IResponseMetaCacheInfo;
    releaseInfo?: IReleaseInfo;
}

type ResponseMetaCacheStatus = "READY" | "PENDING" | "NOCACHE";

interface IResponseMetaCacheInfo {
    cacheHit?: boolean;
    cacheEnabled?: boolean;
    cacheGroup: string;
    cacheMapKey?: string;
    cacheStatus?: ResponseMetaCacheStatus;
}

interface IReleaseInfo {
    releaseId?: number;
    isPreReleaseEnabled?: boolean;
}

export { type ResponseMetaCacheStatus, type IResponseMetadata, type IResponseMetaCacheInfo };
