import type {
    IRouteLocationInterface,
    IRouteParamsInterface,
    IRouteRequestInterface,
    IRouteResponseInterface,
} from "@devowl-wp/api";
import { ERouteHttpVerb } from "@devowl-wp/api";

import type { IContentBlockerTemplate } from "../../../../entity/template/content-blocker/content-blocker.js";

const routeLocationServiceFunctionToggleFavouritePut: IRouteLocationInterface = {
    path: "/template/service/functions/toggleFavourite",
    method: ERouteHttpVerb.PUT,
};

interface IRouteRequestServiceFunctionToggleFavouritePut extends IRouteRequestInterface {
    id: string;
}

interface IRouteParamsServiceFunctionToggleFavouritePut extends IRouteParamsInterface {}

interface IRouteResponseServiceFunctionToggleFavouritePut extends IRouteResponseInterface {
    templateId: string;
    isFavourite: boolean;
    connectedTemplates: IContentBlockerTemplate[];
}

export {
    type IRouteParamsServiceFunctionToggleFavouritePut,
    type IRouteRequestServiceFunctionToggleFavouritePut,
    type IRouteResponseServiceFunctionToggleFavouritePut,
    routeLocationServiceFunctionToggleFavouritePut,
};
