import type { IRouteLocationInterface, IRouteParamsInterface, IRouteRequestInterface } from "@devowl-wp/api";
import { ERouteHttpVerb } from "@devowl-wp/api";

import type { ITemplateMetaData } from "../../../entity/template/meta-data/meta-data.js";

const routeLocationServiceMetaGet: IRouteLocationInterface = {
    path: "/template/services/meta",
    method: ERouteHttpVerb.GET,
};

interface IRouteRequestServiceMetaGet extends IRouteRequestInterface {}

interface IRouteParamsServiceMetaGet extends IRouteParamsInterface {
    allVersions?: boolean;
    filterIdentifiers?: string;
    includeDeleted?: boolean;
}

type IRouteResponseServiceMetaGet = ITemplateMetaData[];

export {
    routeLocationServiceMetaGet,
    type IRouteRequestServiceMetaGet,
    type IRouteParamsServiceMetaGet,
    type IRouteResponseServiceMetaGet,
};
