import type { IRouteLocationInterface, IRouteParamsInterface, IRouteRequestInterface } from "@devowl-wp/api";
import { ERouteHttpVerb } from "@devowl-wp/api";

import type { IServiceTemplate } from "../../../entity/template/service/service.js";

const routeLocationServiceGet: IRouteLocationInterface = {
    path: "/template/service",
    method: ERouteHttpVerb.GET,
};

interface IRouteRequestServiceGet extends IRouteRequestInterface {}

interface IRouteParamsServiceGet extends IRouteParamsInterface {
    /**
     * Will deliver the exact template with given id.
     */
    id?: string;
    /**
     * Will search for the latest template matching this identifier.
     */
    identifier?: string;
}

type IRouteResponseServiceGet = IServiceTemplate;

export {
    routeLocationServiceGet,
    type IRouteRequestServiceGet,
    type IRouteParamsServiceGet,
    type IRouteResponseServiceGet,
};
