import type { IRouteLocationInterface, IRouteParamsInterface, IRouteRequestInterface } from "@devowl-wp/api";
import { ERouteHttpVerb } from "@devowl-wp/api";

import type { IServiceTemplate } from "../../../entity/template/service/service.js";

const routeLocationServicePost: IRouteLocationInterface = {
    path: "/template/service",
    method: ERouteHttpVerb.POST,
};

interface IRouteRequestServicePost extends IRouteRequestInterface {
    serviceTemplate: IServiceTemplate;
}

interface IRouteParamsServicePost extends IRouteParamsInterface {
    /**
     * Skippable names for validation (comma separated list)
     *
     * @see https://app.clickup.com/t/2kav8bg
     */
    skipValidationNames: string;
    /**
     * Allow specific actions on admin imports.
     *
     * @see https://app.clickup.com/t/863gcdu2z
     */
    isImport: boolean;
}

type IRouteResponseServicePost = IServiceTemplate;

export {
    routeLocationServicePost,
    type IRouteRequestServicePost,
    type IRouteParamsServicePost,
    type IRouteResponseServicePost,
};
