import type {
    IRouteLocationInterface,
    IRouteParamsCursorInterface,
    IRouteParamsInterface,
    IRouteRequestInterface,
    IRouteResponseInterface,
} from "@devowl-wp/api";
import { ERouteHttpVerb } from "@devowl-wp/api";

import type { IServiceTemplateClientResponse } from "../../../entity/template/service/service.js";
import type { IResponseMetadata } from "../response-meta.js";

const routeLocationServicesGet: IRouteLocationInterface = {
    path: "/template/services",
    method: ERouteHttpVerb.GET,
};

interface IRouteRequestBodyServicesGet extends IRouteRequestInterface {}

interface IRouteParamsServicesGet extends IRouteParamsInterface, IRouteParamsCursorInterface {
    cursor: string; // example: id:1
    clientUuid: string;
    language: string;
    licenseKey: string;
    limit: number;
    minRequiredRcbVersion: string;
    noCache?: boolean;
    allowAsyncCacheCalculation?: boolean;
}

interface IRouteResponseServicesGet extends IRouteResponseInterface {
    data: IServiceTemplateClientResponse[];
    responseMetadata: IResponseMetadata;
}

export {
    routeLocationServicesGet,
    type IRouteRequestBodyServicesGet,
    type IRouteParamsServicesGet,
    type IRouteResponseServicesGet,
};
