import type {
    IRouteLocationInterface,
    IRouteParamsInterface,
    IRouteRequestInterface,
    IRouteResponseInterface,
} from "@devowl-wp/api";
import { ERouteHttpVerb } from "@devowl-wp/api";

import type { StatisticsEntity } from "../../../../entity/statistics/statistics.js";

const routeLocationServiceStatisticsGet: IRouteLocationInterface = {
    path: "/template/service/statistics",
    method: ERouteHttpVerb.GET,
};

interface IRouteRequestBodyServiceStatisticsGet extends IRouteRequestInterface {}

interface IRouteParamsServiceStatisticsGet extends IRouteParamsInterface {
    favouritesOnly?: boolean;
}

interface IRouteResponseServiceStatisticsGet extends IRouteResponseInterface {
    statistics: {
        services: StatisticsEntity;
    };
}

export {
    type IRouteParamsServiceStatisticsGet,
    type IRouteRequestBodyServiceStatisticsGet,
    type IRouteResponseServiceStatisticsGet,
    routeLocationServiceStatisticsGet,
};
