import { z } from "zod";

import type { InferContract, InferContractParams, InferContractRequest, InferContractResponse } from "@devowl-wp/api";
import { ContractResponse, EHttpStatusCodeSuccess, ERouteHttpVerb, createContract } from "@devowl-wp/api";

import { createUntranslatableSchema } from "../../entity/template/untranslatable.js";
import { createContractGuardJwt } from "../../guard/jwt.js";

const createContractUntranslatablePost = () =>
    createContract({
        z,
        versions: ["1.0.0"],
        route: {
            path: "/template/untranslatable",
            method: ERouteHttpVerb.POST,
        },
        routeDetails: {
            shortDescription: "Create an untranslatable string",
            longDescription: "Create an untranslatable string",
            groups: ["Untranslatable"],
        },
        guards: () => ({
            jwt: createContractGuardJwt(),
        }),
        request: () =>
            z.object({
                text: z.string().nonempty(),
                template: z.object({
                    type: z.enum(["Service", "Content-Blocker"]),
                    identifier: z.string().nonempty(),
                }),
            }),
        response: (context) => ({
            [EHttpStatusCodeSuccess.Created]: new ContractResponse({
                schema: createUntranslatableSchema(context).meta({ id: "UntranslatableCreated" }),
            }),
        }),
    });

type UntranslatablePostContract = InferContract<typeof createContractUntranslatablePost>;

interface IUntranslatablePostContractRequest extends InferContractRequest<typeof createContractUntranslatablePost> {}
interface IUntranslatablePostContractParams extends InferContractParams<typeof createContractUntranslatablePost> {}
interface IUntranslatablePostContractResponse extends InferContractResponse<typeof createContractUntranslatablePost> {}

export {
    type IUntranslatablePostContractParams,
    type IUntranslatablePostContractRequest,
    type IUntranslatablePostContractResponse,
    type UntranslatablePostContract,
    createContractUntranslatablePost,
};
