import type {
    IRouteLocationInterface,
    IRouteParamsInterface,
    IRouteRequestInterface,
    IRouteResponseInterface,
} from "@devowl-wp/api";
import { ERouteHttpVerb } from "@devowl-wp/api";

import type { ITranslationOptions, ITranslationResult } from "../../service/translate.js";

const routeLocationTranslatePost: IRouteLocationInterface = {
    path: "/translate",
    method: ERouteHttpVerb.POST,
};

interface IRouteRequestTranslatePost extends IRouteRequestInterface {
    options: ITranslationOptions;
}

interface IRouteParamsTranslatePost extends IRouteParamsInterface {}

interface IRouteResponseTranslatePost extends IRouteResponseInterface {
    result: ITranslationResult;
}

export {
    routeLocationTranslatePost,
    type IRouteRequestTranslatePost,
    type IRouteParamsTranslatePost,
    type IRouteResponseTranslatePost,
};
