import type {
    IRouteLocationInterface,
    IRouteParamsInterface,
    IRouteRequestInterface,
    IRouteResponseInterface,
    IUserPassword,
} from "@devowl-wp/api";
import { ERouteHttpVerb } from "@devowl-wp/api";

const routeLocationPasswordPost: IRouteLocationInterface = {
    path: "/user/password",
    method: ERouteHttpVerb.POST,
};

interface IRouteRequestPasswordPost extends IRouteRequestInterface {
    password: string;
    salt: string;
}

interface IRouteParamsPasswordPost extends IRouteParamsInterface {}

interface IRouteResponsePasswordPost extends IRouteResponseInterface, Pick<IUserPassword, "password"> {}

export {
    routeLocationPasswordPost,
    type IRouteRequestPasswordPost,
    type IRouteParamsPasswordPost,
    type IRouteResponsePasswordPost,
};
