import type {
    IRouteLocationInterface,
    IRouteParamsInterface,
    IRouteRequestInterface,
    IRouteResponseInterface,
} from "@devowl-wp/api";
import { ERouteHttpVerb } from "@devowl-wp/api";

import type { IUserSession } from "../../../../entity/user/session.js";

const routeLocationUserSessionMagicLinkPost: IRouteLocationInterface = {
    path: "/user/session/magic-link",
    method: ERouteHttpVerb.POST,
};

interface IRouteRequestUserSessionMagicLinkPost extends IRouteRequestInterface {
    user: {
        email: string;
        overwriteEmail?: string;
    };
}

interface IRouteParamsUserSessionMagicLinkPost extends IRouteParamsInterface {}

interface IRouteResponseUserSessionMagicLinkPost extends IRouteResponseInterface {
    userSession: IUserSession;
}

export {
    routeLocationUserSessionMagicLinkPost,
    type IRouteRequestUserSessionMagicLinkPost,
    type IRouteParamsUserSessionMagicLinkPost,
    type IRouteResponseUserSessionMagicLinkPost,
};
