import type {
    IRouteLocationInterface,
    IRouteParamsInterface,
    IRouteRequestInterface,
    IRouteResponseInterface,
} from "@devowl-wp/api";
import { ERouteHttpVerb } from "@devowl-wp/api";

import type { IRcbUserSession } from "./session.rcb.js";

const routeLocationUserSessionPatch: IRouteLocationInterface = {
    path: "/user/session",
    method: ERouteHttpVerb.PATCH,
};

interface IRouteRequestUserSessionPatch extends IRouteRequestInterface {}

interface IRouteParamsUserSessionPatch extends IRouteParamsInterface {}

interface IRouteResponseUserSessionPatch extends IRouteResponseInterface, IRcbUserSession {}

export {
    routeLocationUserSessionPatch,
    type IRouteRequestUserSessionPatch,
    type IRouteParamsUserSessionPatch,
    type IRouteResponseUserSessionPatch,
};
