import type {
    IRouteLocationInterface,
    IRouteParamsInterface,
    IRouteRequestInterface,
    IRouteResponseInterface,
} from "@devowl-wp/api";
import { ERouteHttpVerb } from "@devowl-wp/api";

import type { IRcbUserSession } from "./session.rcb.js";

const routeLocationUserSessionPost: IRouteLocationInterface = {
    path: "/user/session",
    method: ERouteHttpVerb.POST,
};

type MagicLinkLogin = {
    type: "magicLink";
    magicLinkToken: string;
};

type PasswordLogin = {
    type: "password";
    email: string;
    password: string;
};

type UserSession = MagicLinkLogin | PasswordLogin;

interface IRouteRequestUserSessionPost extends IRouteRequestInterface {
    userSession: UserSession;
}

interface IRouteParamsUserSessionPost extends IRouteParamsInterface {}

interface IRouteResponseUserSessionPost extends IRouteResponseInterface, IRcbUserSession {}

export {
    routeLocationUserSessionPost,
    type IRouteRequestUserSessionPost,
    type IRouteParamsUserSessionPost,
    type IRouteResponseUserSessionPost,
    type PasswordLogin,
    type MagicLinkLogin,
};
