import type { TemplateType } from "../entity/template/template.js";

type MaskedOptions = {
    templateType: TemplateType;
    templateIdentifier: string;
};

interface ITranslationOptions {
    source?: string;
    target: string;
    /**
     * The formality level for the translation.
     */
    formality?: ETranslationFormality;
    texts: string[];
    maskedOptions?: MaskedOptions;
}

enum ETranslationFormality {
    /**
     * Use informal language
     */
    Less = "less",
    /**
     * Use formal language
     */
    More = "more",
    /**
     * Use default formality
     */
    Default = "default",
    /**
     * Prefer informal language when possible
     */
    PreferLess = "prefer_less",
    /**
     * Prefer formal language when possible
     */
    PreferMore = "prefer_more",
}

interface ITranslationResult extends ITranslationOptions {
    translations: string[];
    cacheHits: number;
    isSupportedTargetLanguage: boolean;
}

export { ETranslationFormality, type ITranslationOptions, type ITranslationResult, type MaskedOptions };
