# Change Log

All notable changes to this project will be documented in this file.
See [Conventional Commits](https://conventionalcommits.org) for commit guidelines.

## 1.6.3 (2026-02-02)


### Bug Fixes

* avoid passing complete zod schemas to ContractResponse (CU-869bdvdfh)







## 1.6.2 (2026-01-23)

**Note:** This package (@devowl-wp/api) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/node-gitlab-ci 0.8.15</summary>


**_Purpose of dependency:_** _Create dynamic GitLab CI pipelines in JavaScript or TypeScript for each project. Reuse and inherit instructions and avoid duplicate code!_
##### Bug Fixes

* validate container registry image did not catch curl errors correctly (CU-86931jwau)</details>





## 1.6.1 (2026-01-20)


### Bug Fixes

* add HTTP 410 Gone status for deleted reports in order service (CU-8699tgz5g)
* add media upload functionality for logos (CU-8699tgz5g)
* adjust Content-Type handling in fetch client to allow browser to set for FormData (CU-8699tgz5g)
* do not hide internal routes in OpenAPI in non-production environments (CU-8699tgz5g)
* improve developer experience as using schema-mutable methods outside the middleware looses validations and refinements (CU-8699tgz5g)
* prevent duplicate tags in OpenAPI document generation (CU-8699tgz5g)
* review points including 20 (CU-8699tgz5g)
* throw runtime error when refine is used in schema definition (CU-8699tgz5g)


### Code Refactoring

* migrate from Jest to Vitest and clean up related configurations (CU-86931jwau)
* migrate to ESM (CU-861mnuuc5)
* safer usage of imports and exports with TypeScript's verbatimModuleSyntax option (CU-861mhn5rj)
* update refine function parameter naming for consistency across schemas (CU-8699tgz5g)
* use package.json#exports everywhere for ESM preparation (CU-861mnuuc5)


### Documentation

* enhance group management by introducing parent relationships and sorting (CU-8699tgz5g)


### Maintenance

* upgrade to Node 24 (CU-86931jwau)


<details><summary>Development dependency update @devowl-wp/continuous-integration 0.7.13</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Bug Fixes

* only scan current branch with gitleaks (CU-869aw6tca)


##### Code Refactoring

* migrate from Jest to Vitest and clean up related configurations (CU-86931jwau)
* migrate to ESM (CU-861mnuuc5)
* remove deprecated packages which are coming with native Node 24 (CU-86931jwau)
* remove fs-extra, use fs:promise and disallow blocking/sync methods (CU-86931jwau)
* replace execSync with spawnSync for improved command execution consistency and security (CU-86931jwau)
* safer usage of imports and exports with TypeScript's verbatimModuleSyntax option (CU-861mhn5rj)
* use package.json#exports everywhere for ESM preparation (CU-861mnuuc5)


##### Maintenance

* use complyforce.com as production domain (CU-8699th190)</details>

<details><summary>Development dependency update @devowl-wp/eslint-config 0.2.21</summary>


**_Purpose of dependency:_** _Provide eslint configuration for our complete monorepo._
##### Code Refactoring

* migrate from Jest to Vitest and clean up related configurations (CU-86931jwau)
* migrate to ESM (CU-861mnuuc5)
* remove fs-extra, use fs:promise and disallow blocking/sync methods (CU-86931jwau)
* replace execSync with spawnSync for improved command execution consistency and security (CU-86931jwau)
* safer usage of imports and exports with TypeScript's verbatimModuleSyntax option (CU-861mhn5rj)
* use package.json#exports everywhere for ESM preparation (CU-861mnuuc5)


##### Maintenance

* upgrade dependencies (CU-86931jwau)
* upgrade to Node 24 (CU-86931jwau)
* use Relation type for ESM preparation in TypeORM relations (CU-861mnuuc5)</details>

<details><summary>Development dependency update @devowl-wp/monorepo-utils 0.2.22</summary>


**_Purpose of dependency:_** _Predefined monorepo utilities and tasks._
##### Code Refactoring

* migrate to ESM (CU-861mnuuc5)
* remove fs-extra, use fs:promise and disallow blocking/sync methods (CU-86931jwau)
* replace execSync with spawnSync for improved command execution consistency and security (CU-86931jwau)
* safer usage of imports and exports with TypeScript's verbatimModuleSyntax option (CU-861mhn5rj)
* use package.json#exports everywhere for ESM preparation (CU-861mnuuc5)


##### Maintenance

* make CI build work (CU-861mnuuc5)
* upgrade dependencies (CU-86931jwau)</details>

<details><summary>Development dependency update @devowl-wp/node-gitlab-ci 0.8.14</summary>


**_Purpose of dependency:_** _Create dynamic GitLab CI pipelines in JavaScript or TypeScript for each project. Reuse and inherit instructions and avoid duplicate code!_
##### Code Refactoring

* migrate to ESM (CU-861mnuuc5)
* remove deprecated packages which are coming with native Node 24 (CU-86931jwau)
* remove fs-extra, use fs:promise and disallow blocking/sync methods (CU-86931jwau)
* replace execSync with spawnSync for improved command execution consistency and security (CU-86931jwau)
* safer usage of imports and exports with TypeScript's verbatimModuleSyntax option (CU-861mhn5rj)
* use package.json#exports everywhere for ESM preparation (CU-861mnuuc5)


##### Maintenance

* make CI build work (CU-861mnuuc5)</details>

<details><summary>Development dependency update @devowl-wp/npm-licenses 0.1.15</summary>


**_Purpose of dependency:_** _Helper functionalities for your project to validate licenses and generate a disclaimer._
##### Code Refactoring

* migrate to ESM (CU-861mnuuc5)
* use package.json#exports everywhere for ESM preparation (CU-861mnuuc5)</details>

<details><summary>Development dependency update @devowl-wp/ts-config 0.1.19</summary>


**_Purpose of dependency:_** _Predefined compiler options for our backends._
##### Code Refactoring

* migrate to ESM (CU-861mnuuc5)
* safer usage of imports and exports with TypeScript's verbatimModuleSyntax option (CU-861mhn5rj)
* use package.json#exports everywhere for ESM preparation (CU-861mnuuc5)</details>

<details><summary>Development dependency update @devowl-wp/vitest-config 0.2.1</summary>


**_Purpose of dependency:_** _Predefined functionalities for Vitest._
##### Code Refactoring

* migrate from Jest to Vitest and clean up related configurations (CU-86931jwau)
* migrate to ESM (CU-861mnuuc5)
* remove fs-extra, use fs:promise and disallow blocking/sync methods (CU-86931jwau)
* use package.json#exports everywhere for ESM preparation (CU-861mnuuc5)</details>





# 1.6.0 (2026-01-15)


### Features

* refactor new Contract API (CU-8699twn1u)


### Maintenance

* ai review (CU-8699twn1u)
* fix issues found in testing (CU-8699twn1u)
* fix purpose in contracts ((CU-8699twn1u)
* remove package.json#engines from internal packages (CU-86931jwau)







# 1.5.0 (2025-12-04)


### Features

* inital implementation of object-storage package (CU-8697h8axv)
* introduce contract profiles with predefined internal profile to exclude from OpenAPI (CU-8699tgz5g)


<details><summary>Development dependency update @devowl-wp/vitest-config 0.2.0</summary>


**_Purpose of dependency:_** _Predefined functionalities for Vitest._
##### Features

* inital implementation of object-storage package (CU-8697h8axv)</details>





## 1.4.2 (2025-12-02)


### Bug Fixes

* implement missing file multipart upload in contracts (CU-869badh12)
* implement missing file multipart upload in contracts fetch-client (CU-869badh12)







## 1.4.1 (2025-11-21)


### Bug Fixes

* allow to set a x-tagGroups via route details (CU-8699tgz5g)
* remove redundant delivery ack policy handling (CU-869am6b3b)


### Maintenance

* upgrade zod to latest v4 and refactor to zod imports instead of zod/v4 (CU-8699tgz5g)


<details><summary>Development dependency update @devowl-wp/continuous-integration 0.7.12</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Maintenance

* introduce secret-scanner with gitleaks (CU-869aw6tca)</details>

<details><summary>Development dependency update @devowl-wp/eslint-config 0.2.20</summary>


**_Purpose of dependency:_** _Provide eslint configuration for our complete monorepo._
##### Maintenance

* upgrade zod to latest v4 and refactor to zod imports instead of zod/v4 (CU-8699tgz5g)</details>





# 1.4.0 (2025-10-15)


### Bug Fixes

* allow to create literal error code responses (CU-8699tgz5g)
* allow to define routes to be a webhook (CU-8699tgz5g)
* enhance vendor management contracts with new API endpoints and schema updates (CU-8699tgz5g)
* make optional recursion schema properties work as expected (CU-8699tgz5g)


### Continuous Integration

* correctly type check with --project instead of cd into the TypeScript project folder (CU-8697h8axv)


### Documentation

* user session and magic link routes improved (CU-8699tgz5g)


### Features

* enhance vendor and user management with new API endpoints and schema updates (CU-8699tgz5g)
* introduce a contract-first design for message brokers with delivery-tuning (CU-869am6b3b)


<details><summary>Development dependency update @devowl-wp/ts-config 0.1.18</summary>


**_Purpose of dependency:_** _Predefined compiler options for our backends._
##### Continuous Integration

* correctly type check with --project instead of cd into the TypeScript project folder (CU-8697h8axv)</details>





## 1.3.3 (2025-09-24)

**Note:** This package (@devowl-wp/api) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/continuous-integration 0.7.10</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Continuous Integration

* oss-extract only in master pipeline (CU-869ad3694)</details>

<details><summary>Development dependency update @devowl-wp/eslint-config 0.2.19</summary>


**_Purpose of dependency:_** _Provide eslint configuration for our complete monorepo._
##### Build System

* introduce .oss.ts and oss-extract CLI (CU-869ad3694)</details>

<details><summary>Development dependency update @devowl-wp/monorepo-utils 0.2.19</summary>


**_Purpose of dependency:_** _Predefined monorepo utilities and tasks._
##### Build System

* introduce .oss.ts and oss-extract CLI (CU-869ad3694)</details>





## 1.3.2 (2025-09-12)


### Bug Fixes

* allow v1, v2, ... versioning beside semantic versioning for contract (CU-8699tgz5g)
* remove undefined values from URLSearchParams (CU-869ad2n4f)


### Documentation

* add another example for multiple nested recursion objects (CU-8699tgz5g)
* uncaught Error: Cannot find module 'node:async_hooks'







## 1.3.1 (2025-09-04)


### Bug Fixes

* content length is not always respond by server if using e.g. Cloudflare with Transfer-Encoding: chunked (CU-869ac6g7m)







# 1.3.0 (2025-09-04)


### Bug Fixes

* a fetch client need to pass the API version (CU-869a8xjjf)
* run guard schema validations isolated from complete contract schema validation (CU-8699z5dt7)


### Code Refactoring

* migrate from @devowl-wp/api-request to new fetch client (CU-869a8xjjf)


### Documentation

* add README for contract-first instroductions (CU-8699z5dt7)


### Features

* introduce type-safe createFetchClient from all contracts (CU-869a8xjjf)


### Tests

* add Vitest test runner for our contracts and introduce a first draft for a RPC client type generator (CU-869a8xjjf)


<details><summary>Development dependency update @devowl-wp/continuous-integration 0.7.9</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Build System

* introduce Complyforce API backend (CU-8699tdjp0)


##### Continuous Integration

* pnpm-lock.yaml should be considered as common file change (CU-869a875re)</details>

<details><summary>Development dependency update @devowl-wp/eslint-config 0.2.18</summary>


**_Purpose of dependency:_** _Provide eslint configuration for our complete monorepo._
##### Bug Fixes

* switch from node fetch to undici request and make it work with streams and content encoding (CU-86997627z)</details>





## 1.2.1 (2025-08-25)


### Bug Fixes

* make API contracts aware of recursion, parameters to object for refinable schema and switch language contexts correctly (CU-8699z5dt7)







# 1.2.0 (2025-08-08)


### Features

* make API contracts compatible with OpenAPI, move guards to API definition and automatically generate API UI (CU-8699z5dt7)







## 1.1.9 (2025-07-29)

**Note:** This package (@devowl-wp/api) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/continuous-integration 0.7.8</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Continuous Integration

* resource group for Docker Review deployments to avoid race condition in Swarm subnet allocation (CU-8699xj5ue)


##### Tests

* introduce optional playwright coverage with c8 (CU-8699761na)</details>

<details><summary>Development dependency update @devowl-wp/monorepo-utils 0.2.17</summary>


**_Purpose of dependency:_** _Predefined monorepo utilities and tasks._
##### Bug Fixes

* compatibility with latest version of Taskfile (CU-8699761na)</details>





## 1.1.8 (2025-07-16)


### Bug Fixes

* introduce translation options for fields and enhance translation handling in forms (CU-8699f32x9)







## 1.1.7 (2025-07-10)

**Note:** This package (@devowl-wp/api) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/continuous-integration 0.7.7</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Continuous Integration

* allow to recreate the gitlab-ci image manually (CU-8696heugb)
* docker review should not rely on manual containerize job (CU-8696heugb)</details>

<details><summary>Development dependency update @devowl-wp/eslint-config 0.2.17</summary>


**_Purpose of dependency:_** _Provide eslint configuration for our complete monorepo._
##### Tests

* vitest/prefer-expect-resolves (CU-8698r80f9)</details>

<details><summary>Development dependency update @devowl-wp/ts-config 0.1.17</summary>


**_Purpose of dependency:_** _Predefined compiler options for our backends._
##### Bug Fixes

* stabilize scrolling and stats with timer (CU-8696heugb)</details>





## 1.1.6 (2025-06-25)


### Bug Fixes

* make contract and entity schemas translatable with i18next (CU-8697uqxnq)


### Code Refactoring

* introduce contracts for api case study (CU-8697uqxnq)


### Maintenance

* implement learnings from presentation for API contracts (CU-8697uqxnq)
* started to work on a type-safe client fetch wrapper (CU-8697uqxnq)
* use PNPM catalog feature (CU-8699ec2dm)
* use zod/v4 instead of v4 beta package and use Zod locales for error messages (CU-8697uqxnq9)


<details><summary>Development dependency update @devowl-wp/continuous-integration 0.7.6</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Continuous Integration

* only release clouflare worker when changes are made (CU-869954ppf)


##### Maintenance

* use PNPM catalog feature (CU-8699ec2dm)</details>

<details><summary>Development dependency update @devowl-wp/eslint-config 0.2.16</summary>


**_Purpose of dependency:_** _Provide eslint configuration for our complete monorepo._
##### Maintenance

* upgrade to TypeScript 5.8 (CU-8697uqxnq)
* use PNPM catalog feature (CU-8699ec2dm)
* use zod/v4 instead of v4 beta package and use Zod locales for error messages (CU-8697uqxnq9)</details>

<details><summary>Development dependency update @devowl-wp/monorepo-utils 0.2.15</summary>


**_Purpose of dependency:_** _Predefined monorepo utilities and tasks._
##### Maintenance

* use PNPM catalog feature (CU-8699ec2dm)</details>

<details><summary>Development dependency update @devowl-wp/node-gitlab-ci 0.8.8</summary>


**_Purpose of dependency:_** _Create dynamic GitLab CI pipelines in JavaScript or TypeScript for each project. Reuse and inherit instructions and avoid duplicate code!_
##### Maintenance

* upgrade to TypeScript 5.8 (CU-8697uqxnq)
* use PNPM catalog feature (CU-8699ec2dm)</details>

<details><summary>Development dependency update @devowl-wp/ts-config 0.1.16</summary>


**_Purpose of dependency:_** _Predefined compiler options for our backends._
##### Bug Fixes

* make the headless content url scanner work in ESM and CJS (CU-8696heugb)


##### Maintenance

* upgrade to TypeScript 5.8 (CU-8697uqxnq)</details>





## 1.1.5 (2025-05-15)

**Note:** This package (@devowl-wp/api) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/continuous-integration 0.7.5</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Build System

* add support for Cloudflare workers through wrangler CLI (CU-8698nqyb0)


##### Continuous Integration

* deploy Cloudflare workers in master and develop environment (CU-8698nqyb0)
* make Cloudflare worker builds available in review apps through own docker image packaged with Wrangler (CU-8698nqyb0)</details>

<details><summary>Development dependency update @devowl-wp/eslint-config 0.2.15</summary>


**_Purpose of dependency:_** _Provide eslint configuration for our complete monorepo._
##### Build System

* add support for Cloudflare workers through wrangler CLI (CU-8698nqyb0)</details>

<details><summary>Development dependency update @devowl-wp/ts-config 0.1.15</summary>


**_Purpose of dependency:_** _Predefined compiler options for our backends._
##### Build System

* add support for Cloudflare workers through wrangler CLI (CU-8698nqyb0)</details>





## 1.1.4 (2025-05-13)


### Code Refactoring

* use lint-staged with correct monorepo support (CU-8699154vj)


<details><summary>Development dependency update @devowl-wp/continuous-integration 0.7.4</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Code Refactoring

* move internal apps to our monorepo codebase and introduce swarm (CU-31mn75v)
* use lint-staged with correct monorepo support (CU-8699154vj)</details>

<details><summary>Development dependency update @devowl-wp/eslint-config 0.2.14</summary>


**_Purpose of dependency:_** _Provide eslint configuration for our complete monorepo._
##### Code Refactoring

* use lint-staged with correct monorepo support (CU-8699154vj)</details>

<details><summary>Development dependency update @devowl-wp/monorepo-utils 0.2.13</summary>


**_Purpose of dependency:_** _Predefined monorepo utilities and tasks._
##### Bug Fixes

* use first mounted container (CU-8694v2pwc)


##### Code Refactoring

* use lint-staged with correct monorepo support (CU-8699154vj)</details>

<details><summary>Development dependency update @devowl-wp/node-gitlab-ci 0.8.6</summary>


**_Purpose of dependency:_** _Create dynamic GitLab CI pipelines in JavaScript or TypeScript for each project. Reuse and inherit instructions and avoid duplicate code!_
##### Code Refactoring

* use lint-staged with correct monorepo support (CU-8699154vj)</details>

<details><summary>Development dependency update @devowl-wp/npm-licenses 0.1.14</summary>


**_Purpose of dependency:_** _Helper functionalities for your project to validate licenses and generate a disclaimer._
##### Code Refactoring

* use lint-staged with correct monorepo support (CU-8699154vj)</details>

<details><summary>Development dependency update @devowl-wp/ts-config 0.1.14</summary>


**_Purpose of dependency:_** _Predefined compiler options for our backends._
##### Code Refactoring

* use lint-staged with correct monorepo support (CU-8699154vj)</details>





## 1.1.3 (2025-04-25)

**Note:** This package (@devowl-wp/api) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/continuous-integration 0.7.3</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Continuous Integration

* connect to REVIEW_APP ssh agent (CU-8698fyv1c)
* connect to REVIEW_APP ssh agent (CU-8698fyv1c)
* use GIT_STRATEGY none to fetch the commit in review stop job (CU-8698fyv1c)</details>

<details><summary>Development dependency update @devowl-wp/eslint-config 0.2.13</summary>


**_Purpose of dependency:_** _Provide eslint configuration for our complete monorepo._
##### Bug Fixes

* quill editor and WYSIWYG editors are not rendered (CU-8698tv43q)</details>





## 1.1.2 (2025-04-08)

**Note:** This package (@devowl-wp/api) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/continuous-integration 0.7.2</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Maintenance

* create owlreview.de certificates instead of swarm.owlreview.de (CU-8697hja46)
* migrate to docker swarm for multi-instance capability (CU-8697hja46)</details>

<details><summary>Development dependency update @devowl-wp/node-gitlab-ci 0.8.4</summary>


**_Purpose of dependency:_** _Create dynamic GitLab CI pipelines in JavaScript or TypeScript for each project. Reuse and inherit instructions and avoid duplicate code!_
##### Maintenance

* migrate to docker swarm for multi-instance capability (CU-8697hja46)</details>





## 1.1.1 (2025-03-27)


### Code Refactoring

* update ESLint to v9, organize imports, and refactor imports for ESM preparation (CU-8694tbwme)


<details><summary>Development dependency update @devowl-wp/continuous-integration 0.7.1</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Code Refactoring

* update ESLint to v9, organize imports, and refactor imports for ESM preparation (CU-8694tbwme)


##### Continuous Integration

* create wildcard certificate for owlsrv.de (CU-8697hja46)</details>

<details><summary>Development dependency update @devowl-wp/eslint-config 0.2.12</summary>


**_Purpose of dependency:_** _Provide eslint configuration for our complete monorepo._
##### Code Refactoring

* update ESLint to v9, organize imports, and refactor imports for ESM preparation (CU-8694tbwme)</details>

<details><summary>Development dependency update @devowl-wp/monorepo-utils 0.2.10</summary>


**_Purpose of dependency:_** _Predefined monorepo utilities and tasks._
##### Code Refactoring

* update ESLint to v9, organize imports, and refactor imports for ESM preparation (CU-8694tbwme)</details>

<details><summary>Development dependency update @devowl-wp/node-gitlab-ci 0.8.3</summary>


**_Purpose of dependency:_** _Create dynamic GitLab CI pipelines in JavaScript or TypeScript for each project. Reuse and inherit instructions and avoid duplicate code!_
##### Code Refactoring

* update ESLint to v9, organize imports, and refactor imports for ESM preparation (CU-8694tbwme)</details>

<details><summary>Development dependency update @devowl-wp/ts-config 0.1.13</summary>


**_Purpose of dependency:_** _Predefined compiler options for our backends._
##### Code Refactoring

* update ESLint to v9, organize imports, and refactor imports for ESM preparation (CU-8694tbwme)</details>





# 1.1.0 (2025-03-04)


### Bug Fixes

* corrected calculation full machine translation and introduce flag ignoreOnMachineTranslation (CU-8692xtha4)
* enhance machine translation with granular translation options (CU-8692xtha4)
* introduce machine translation status (CU-8692xtha4)


### Features

* introduce fully machine translated flag to translation status (CU-8692xtha4)
* introduce machine translation including relational metadata service WiP (CU-8692xtha4)


<details><summary>Development dependency update @devowl-wp/continuous-integration 0.7.0</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Continuous Integration

* build docker containers only after the install job (CU-8697hja46)
* generate production certificates for devowl.io and owlinfra.de (CU-8697hja46)
* generate production Lets Encrypt certificates instead of staging server (CU-8697hja46)


##### Features

* run develop pipeline which creates review app certificates on new branch (CU-8697hja46)</details>

<details><summary>Development dependency update @devowl-wp/eslint-config 0.2.11</summary>


**_Purpose of dependency:_** _Provide eslint configuration for our complete monorepo._
##### Maintenance

* implement transaction handling in email and storage operations, update ESLint rules for ORM CUD methods (CU-861mfub3j)</details>





## 1.0.2 (2025-02-25)

**Note:** This package (@devowl-wp/api) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/continuous-integration 0.6.8</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Continuous Integration

* create checksum over all certificates (CU-8697hja46)
* generate certificates for swarm revie apps (CU-8697hja46)
* generate regularily certificates with go-acme/lego for our CI runners (CU-8697hja46)
* generate regularily wildcard certificates with go-acme/lego for our CI runners (CU-8697hja46)
* remove orphan certificates (CU-8697hja46)
* use home-runner for WordPress.org push (CU-86980hdd8)</details>

<details><summary>Development dependency update @devowl-wp/node-gitlab-ci 0.8.1</summary>


**_Purpose of dependency:_** _Create dynamic GitLab CI pipelines in JavaScript or TypeScript for each project. Reuse and inherit instructions and avoid duplicate code!_
##### Continuous Integration

* generate certificates for swarm revie apps (CU-8697hja46)</details>





## 1.0.1 (2025-02-06)

**Note:** This package (@devowl-wp/api) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/continuous-integration 0.6.7</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Bug Fixes

* always validate docker images when built (CU-8696heugb)


##### Build System

* streamline docker and setup.sh into a Taskfile.setup.yml (CU-8696k3cct)


##### Continuous Integration

* always validate and try to fix docker images (CU-8697pj0tx)
* validate docker images with new CNCF scopes and socket hang up in Weblate translations (CU-8697pj0tx)


##### Tests

* make static files inclusive domain mapping available in playwright tests and create first test (CU-8695mtnyu)</details>

<details><summary>Development dependency update @devowl-wp/node-gitlab-ci 0.8.0</summary>


**_Purpose of dependency:_** _Create dynamic GitLab CI pipelines in JavaScript or TypeScript for each project. Reuse and inherit instructions and avoid duplicate code!_
##### Continuous Integration

* validate docker images with new CNCF scopes and socket hang up in Weblate translations (CU-8697pj0tx)


##### Features

* new command merge-request-tree (also as VSCode task) to visually show Merge Requests (CU-8692xtha4)</details>





# 1.0.0 (2024-11-07)


### Maintenance

* initial release (CU-869656drt)


### BREAKING CHANGES

* With Real Cookie Banner v5 we enter v1 of dependency packages.







## 0.5.27 (2024-10-23)


### Code Refactoring

* remove jest and phpunit from packages which do not use it (CU-8695mtnyu)


<details><summary>Development dependency update @devowl-wp/continuous-integration 0.6.6</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Code Refactoring

* remove jest and phpunit from packages which do not use it (CU-8695mtnyu)


##### Maintenance

* migrate away from envkey-source to infisical (CU-86959qnq2)


##### Tests

* port fast-html-tag and headless-content-blocker to TypeScript with Vitest tests (CU-8695mtnyu)</details>

<details><summary>Development dependency update @devowl-wp/eslint-config 0.2.10</summary>


**_Purpose of dependency:_** _Provide eslint configuration for our complete monorepo._
##### Tests

* port fast-html-tag and headless-content-blocker to TypeScript with Vitest tests (CU-8695mtnyu)</details>

<details><summary>Development dependency update @devowl-wp/node-gitlab-ci 0.7.16</summary>


**_Purpose of dependency:_** _Create dynamic GitLab CI pipelines in JavaScript or TypeScript for each project. Reuse and inherit instructions and avoid duplicate code!_
##### Maintenance

* migrate away from envkey-source to infisical (CU-86959qnq2)</details>





## 0.5.26 (2024-09-26)

**Note:** This package (@devowl-wp/api) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/continuous-integration 0.6.5</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Bug Fixes

* provide APP_NAME and APP_VERSION in backend environment (CU-8695emete)
* restore production database dump app-versionized (CU-8695emete)</details>

<details><summary>Development dependency update @devowl-wp/monorepo-utils 0.2.5</summary>


**_Purpose of dependency:_** _Predefined monorepo utilities and tasks._
##### Continuous Integration

* make public changelog generation work again with latest Taskfile version (CU-8695kgrpr)


##### Maintenance

* update retypeapp (CU-8695kgrpr)</details>





## 0.5.25 (2024-08-28)


### Bug Fixes

* apply new eslint rules (CU-861n9jg7k)
* introduce translation flag statistics and entity display (CU-861n9jg7k)
* introduce translation flags for translatable strings (CU-8693travj)


### Code Refactoring

* reordering vars (CU-861n9jg7k)







## 0.5.24 (2024-07-16)


### Maintenance

* suppress logs from requests from nullers (CU-8694xa392)







## 0.5.23 (2024-06-20)


### Build System

* remove babel-loader and babel toolchain and introduce SWC (CU-8694pt2j7)


### Maintenance

* **deps :** pin dependencies
* **deps :** update npm all dependencies (non-major)
* upgrade prettier v3 together with eslint flat config and run on all files (fix, format, CU-8694qg0t9)


<details><summary>Development dependency update @devowl-wp/continuous-integration 0.6.4</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Continuous Integration

* introduce Renovate bot for dependency update automation (CU-8694qg0t9)


##### Maintenance

* **deps :** pin dependencies
* **deps :** update npm all dependencies (non-major)
* update renovate.json (CU-8694qg0t9)
* upgrade prettier v3 together with eslint flat config and run on all files (fix, format, CU-8694qg0t9)</details>

<details><summary>Development dependency update @devowl-wp/eslint-config 0.2.8</summary>


**_Purpose of dependency:_** _Provide eslint configuration for our complete monorepo._
##### Maintenance

* **deps :** pin dependencies
* **deps :** update npm (non-major)
* **deps :** update npm all dependencies (non-major)
* upgrade prettier v3 together with eslint flat config and run on all files (fix, format, CU-8694qg0t9)</details>

<details><summary>Development dependency update @devowl-wp/monorepo-utils 0.2.4</summary>


**_Purpose of dependency:_** _Predefined monorepo utilities and tasks._
##### Continuous Integration

* remove npm-update-checker CLI command as we use Renovate now (CU-8694qg0t9)


##### Maintenance

* **deps :** pin dependencies
* **deps :** pin dependencies
* **deps :** pin dependencies
* **deps :** update npm all dependencies (non-major)
* update commander and adm-zip (CU-8694qg0t9)
* update some major dependencies (CU-8694qg0t9)
* upgrade prettier v3 together with eslint flat config and run on all files (fix, format, CU-8694qg0t9)</details>

<details><summary>Development dependency update @devowl-wp/node-gitlab-ci 0.7.14</summary>


**_Purpose of dependency:_** _Create dynamic GitLab CI pipelines in JavaScript or TypeScript for each project. Reuse and inherit instructions and avoid duplicate code!_
##### Continuous Integration

* introduce Renovate bot for dependency update automation (CU-8694qg0t9)


##### Maintenance

* **deps :** pin dependencies
* **deps :** pin dependencies
* **deps :** update npm all dependencies (non-major)
* update commander and adm-zip (CU-8694qg0t9)
* update some major dependencies (CU-8694qg0t9)
* upgrade prettier v3 together with eslint flat config and run on all files (fix, format, CU-8694qg0t9)</details>





## 0.5.22 (2024-05-29)

**Note:** This package (@devowl-wp/api) has been updated because a dependency, which is also shipped with this package, has changed.







## 0.5.21 (2024-04-25)


### Bug Fixes

* introducing password login in rcb (CU-86936my3v)


### Refactoring

* introduce user base interfaces (CU-86936my3v)







## 0.5.20 (2024-02-26)

**Note:** This package (@devowl-wp/api) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/continuous-integration 0.6.2</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Performance

* improve performance by not removing cookie banner from DOM after accepting for better INP in Google PageSpeed (CU-8693n1cc5)


##### Refactoring

* move all consent relevant structures and procedures to @devowl-wp/cookie-consent-management (CU-8693n1cc5)</details>

<details><summary>Development dependency update @devowl-wp/eslint-config 0.2.7</summary>


**_Purpose of dependency:_** _Provide eslint configuration for our complete monorepo._
##### Performance

* improve Total Blocking Time in Page Speed Insights by yielding the main thread for TCF cookie banner (CU-8693n1cc5)</details>





## 0.5.19 (2024-01-25)

**Note:** This package (@devowl-wp/api) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/eslint-config 0.2.6</summary>


**_Purpose of dependency:_** _Provide eslint configuration for our complete monorepo._
##### Maintenance

* update to antd@5 (CU-863gku332)</details>

<details><summary>Development dependency update @devowl-wp/node-gitlab-ci 0.7.11</summary>


**_Purpose of dependency:_** _Create dynamic GitLab CI pipelines in JavaScript or TypeScript for each project. Reuse and inherit instructions and avoid duplicate code!_
##### Continuous Integration

* use project ID to read associated merge request for pipeline (CU-apv5uu)</details>





## 0.5.18 (2024-01-18)

**Note:** This package (@devowl-wp/api) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/continuous-integration 0.6.0</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Bug Fixes

* output ci summary for review application URLs for traefik v2 (CU-2rjtd0)


##### Continuous Integration

* automatically retry to fetch the git repository three times when there is a temporary error (CU-8693j5ngt)
* deploy backends in production to docker-host-6.owlsrv.de (CU-2rjtd0)


##### Features

* introduce public-changelogs command (CU-2mjxz4x)</details>

<details><summary>Development dependency update @devowl-wp/monorepo-utils 0.2.0</summary>


**_Purpose of dependency:_** _Predefined monorepo utilities and tasks._
##### Features

* introduce public-changelogs command (CU-2mjxz4x)</details>





## 0.5.17 (2023-12-21)

**Note:** This package (@devowl-wp/api) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/continuous-integration 0.5.1</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Bug Fixes

* correctly check for the SHA of the latest master branch (CU-8693bzjkb)


##### Maintenance

* upgrade to PHP 8.2 including composer packages (CU-arua06)</details>

<details><summary>Development dependency update @devowl-wp/eslint-config 0.2.5</summary>


**_Purpose of dependency:_** _Provide eslint configuration for our complete monorepo._
##### Maintenance

* upgrade to PHP 8.2 including composer packages (CU-arua06)</details>





## 0.5.16 (2023-12-19)

**Note:** This package (@devowl-wp/api) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/continuous-integration 0.5.0</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Continuous Integration

* rotate transaction_ids_by_target_id every 14 days (CU-86937dv6w)
* upload did not work with newer Debian version, disable StrictHostKeyChecking for lftp upload (CU-86937dw3d)


##### Features

* allow to skip publish of packages by regular expression in merge request description with target branch master (CU-8693bzjkb)</details>

<details><summary>Development dependency update @devowl-wp/monorepo-utils 0.1.13</summary>


**_Purpose of dependency:_** _Predefined monorepo utilities and tasks._
##### Bug Fixes

* show skipped publish packages as those in the generated CHANGELOG.md files (CU-8693bzjkb)</details>





## 0.5.15 (2023-11-28)

**Note:** This package (@devowl-wp/api) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/continuous-integration 0.4.5</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Refactoring

* remove all cypress dependencies and tests (CU-8692yek74)


##### Testing

* introduce @devowl-wp/playwright-utils with smoke test functionality (CU-8692yek74)</details>

<details><summary>Development dependency update @devowl-wp/eslint-config 0.2.4</summary>


**_Purpose of dependency:_** _Provide eslint configuration for our complete monorepo._
##### Refactoring

* remove all cypress dependencies and tests (CU-8692yek74)</details>

<details><summary>Development dependency update @devowl-wp/node-gitlab-ci 0.7.9</summary>


**_Purpose of dependency:_** _Create dynamic GitLab CI pipelines in JavaScript or TypeScript for each project. Reuse and inherit instructions and avoid duplicate code!_
##### Bug Fixes

* update Gitlab YAML typings (CU-8692yek74)</details>





## 0.5.14 (2023-11-24)

**Note:** This package (@devowl-wp/api) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/continuous-integration 0.4.4</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Continuous Integration

* show inconsistent translations always in translation status (CU-86932cagc)
* validate production docker compose config on compose YAML changes (CU-86934wg6z)</details>

<details><summary>Development dependency update @devowl-wp/node-gitlab-ci 0.7.8</summary>


**_Purpose of dependency:_** _Create dynamic GitLab CI pipelines in JavaScript or TypeScript for each project. Reuse and inherit instructions and avoid duplicate code!_
##### Bug Fixes

* also delete skipped pipelines and pipelines of deleted branches</details>





## 0.5.13 (2023-10-27)


### Documentation

* update JSDoc, make some methods private and extend some typings (CU-866avtm7z)


<details><summary>Development dependency update @devowl-wp/node-gitlab-ci 0.7.7</summary>


**_Purpose of dependency:_** _Create dynamic GitLab CI pipelines in JavaScript or TypeScript for each project. Reuse and inherit instructions and avoid duplicate code!_
##### Continuous Integration

* purge master pipelines after 90 days instead of 360</details>





## 0.5.12 (2023-10-12)

**Note:** This package (@devowl-wp/api) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/continuous-integration 0.4.2</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Maintenance

* major update typescript [@typescript-eslint](https://git.devowl.io/typescript-eslint) typedoc (CU-3cj43t)
* update Lerna v7 (CU-31956up)</details>

<details><summary>Development dependency update @devowl-wp/eslint-config 0.2.3</summary>


**_Purpose of dependency:_** _Provide eslint configuration for our complete monorepo._
##### Maintenance

* major update typescript [@typescript-eslint](https://git.devowl.io/typescript-eslint) typedoc (CU-3cj43t)</details>

<details><summary>Development dependency update @devowl-wp/monorepo-utils 0.1.9</summary>


**_Purpose of dependency:_** _Predefined monorepo utilities and tasks._
##### Continuous Integration

* include changelogs from dependencies (CU-2k54tcb)


##### Maintenance

* major update commander (CU-3cj43t)
* major update typescript [@typescript-eslint](https://git.devowl.io/typescript-eslint) typedoc (CU-3cj43t)
* update Lerna v7 (CU-31956up)</details>

<details><summary>Development dependency update @devowl-wp/node-gitlab-ci 0.7.6</summary>


**_Purpose of dependency:_** _Create dynamic GitLab CI pipelines in JavaScript or TypeScript for each project. Reuse and inherit instructions and avoid duplicate code!_
##### Maintenance

* major update commander (CU-3cj43t)
* major update jest-junit glob @types/jest jest ts-jest (CU-3cj43t)
* major update typescript [@typescript-eslint](https://git.devowl.io/typescript-eslint) typedoc (CU-3cj43t)</details>





## 0.5.11 (2023-09-29)


### docs

* remove not understandable commit messages from changelog (CU-861n7an31)





## 0.5.10 (2023-09-07)


### fix

* replaced old full translation check method (CU-866aw0t3p)





## 0.5.9 (2023-09-06)


### fix

* added translation statistic information and entity translation type annotations (CU-861n1cg3c)
* cursor naming (CU-863gke74n)





## 0.5.8 (2023-08-28)

**Note:** This package (@devowl-wp/api) has been updated because a dependency, which is also shipped with this package, has changed.





## 0.5.7 (2023-08-02)

**Note:** This package (@devowl-wp/api) has been updated because a dependency, which is also shipped with this package, has changed.





## 0.5.6 (2023-07-06)


### fix

* enhanced process to handle scenarios where both the source values and the translations are missing (CU-861mznmb2)
* internal server error in release (CU-861mznmb2)


### refactor

* introduce custom ESLint rules ability in @devowl-wp/eslint-config (CU-863gxjbn4)





## 0.5.5 (2023-05-22)

**Note:** This package (@devowl-wp/api) has been updated because a dependency, which is also shipped with this package, has changed.





## 0.5.4 (2023-05-21)


### chore

* remove dotenv package (CU-861m6e3mz)





## 0.5.3 (2023-05-11)


### refactor

* moved types from backend-packages api to api-packages (CU-863g9yk3k)





## 0.5.2 (2023-04-24)

**Note:** This package (@devowl-wp/api) has been updated because a dependency, which is also shipped with this package, has changed.





## 0.5.1 (2023-04-19)


### fix

* introducing full-translation checks including translation merge (CU-861mnckax)


### refactor

* introduce taskfile.dev Taskfiles (CU-85zrrymj0)





# 0.5.0 (2023-03-21)


### chore

* update dependencies including TypeScript 4.9, antd and eslint (CU-85zrqk9pd)


### feat

* handle unsupported file type (CU-382phpe)


### fix

* added types for media and cursor (CU-3389fw3)
* review #1 fixes (CU-861m57nyb)





## 0.4.1 (2023-03-14)

**Note:** This package (@devowl-wp/api) has been updated because a dependency, which is also shipped with this package, has changed.





# 0.4.0 (2023-02-15)


### feat

* extended merge strategy implementation for service-cloud consumer clients (CU-863g03gcr)





# 0.3.0 (2023-01-10)


### feat

* introduced utility types Modify and Remove, and entity sub-types NonConfidential and Constructor (CU-37bnpy4)
* response as CSV file (CU-37bnpy4)





## 0.2.1 (2022-12-22)


### chore

* update all package.json to resolve release conflicts (CU-382p4kb)


### fix

* make WordPress plugins and packages capable to API packages location definitions (CU-861m3ktht)


### refactor

* extended entity validator (CU-861m3r5f3)





# 0.2.0 (2022-12-12)


### chore

* introduce api-packages beside backend-packages (CU-33tam4h)


### feat

* added fieldName to IValidationError (CU-37bu7g0)


### refactor

* introduce @devowl/api-real-cookie-banner package (CU-33tam4h)
