enum ETranslateOption {
    Copy = "copy",
    Translate = "translate",
    Skip = "skip",
    Hidden = "hidden",
}

type TranslatableOptions = {
    /**
     * Indicates whether the translation is optional for the property to be recognized as fully translated.
     */
    isOptional?: boolean;
    /**
     * A list of strings that indicate the property is empty by default. This is useful for cases where certain values represent empty content.
     *
     * Examples:
     * - QuillEditor: "<p><br></p>"
     */
    knownEmptyDefaults?: string[];
    /**
     * Indicates whether the property should be ignored on machine translation status calculation.
     * If true, the property will not be considered when calculating the machine translation status.
     * CU-8692xtha4
     */
    ignoreOnMachineTranslationStatus?: boolean;
    /**
     * The default translation option for this field when using machine translation.
     * This allows you to specify whether the field should be copied, translated, or skipped by default.
     */
    defaultTranslateOption?: ETranslateOption;
    /**
     * Use this option if the property represents a relation between entities.
     *
     * This allows to respect the completeness of a relation to be respected when calculating the completeness
     * of the parent entity.
     */
    isRelation?: boolean;
    /**
     * Indicates whether the property is an array of relations.
     */
    isRelationArray?: boolean;
    /**
     * The entity class name of the relation.
     */
    relationName?: string;
    /**
     * The target options for the relation.
     */
    relationOptions?: TranslatablesOptions[];
    /**
     * By default, this is the class name where the translatable property is annotated. You can specify a custom target name.
     */
    targetName?: string;
    /**
     * Allows you to add custom logic for checking if the property is translated.
     */
    customIsPropertyTranslated?: (translation: any, option: TranslatablesOptions) => boolean;
};

type TranslatablesOptions = {
    propertyName: string;
} & TranslatableOptions;

export { type TranslatableOptions, type TranslatablesOptions, ETranslateOption };
