import type { ITranslationProperties } from "./translation-properties.js";

/**
 * Minimum/obligatory properties needed for a translation.
 */
interface ITranslatableProperties {
    id: string;
    language: string;
}

/**
 * Information about translation status including details about optional, required and base value fields.
 */
interface ITranslationStatus extends ITranslationProperties {
    language: string;
    isTranslationComplete?: boolean;
    isTranslationCompleteRecursive?: boolean;
    baseValueFields?: string[];
    machineTranslationStatus?: EMachineTranslationStatus;
}

enum EMachineTranslationStatus {
    NoTranslation = "no-translation",
    Full = "full",
    Partly = "partly",
}

export { type ITranslatableProperties, type ITranslationStatus, EMachineTranslationStatus };
