/**
 * Represents a basic user interface which is used globally.
 */
interface IUserBase {
    /** The unique identifier for the user. */
    id: string;
    /** The date when the user was created. */
    createdAt: Date;

    /** The email address of the user. */
    email: string;
    /** The MD5 hash of the user's email address. */
    emailMd5: string;
    /** An optional unconfirmed email address of the user. */
    unconfirmedEmail?: string;

    /** The first name of the user. */
    firstName: string;
    /** The last name of the user. */
    lastName: string;
}

export { type IUserBase };
