/**
 * Optional interface adapter to add roles and roleParameters to a user.
 *
 * Key value based role parameters object for specific definitions.
 * This was initially introduced for (CU-86936my3v)
 */
interface IUserRoles<RoleType, RoleParametersType> {
    /** Different types, like admin, ... */
    role: RoleType;

    /** Defined by application layer, might be key value based. */
    roleParameters: RoleParametersType;
}

export { type IUserRoles };
