import z from "zod";

import { createRefinableSchema } from "./utility-types/create-refinable-schema.js";

import type { CreateContractContext, InferSchemaFromRefinableSchema } from "./webserver/contract.js";

enum EStorageProvider {
    Scaleway = "scaleway-s3",
}

enum EStorageClass {
    Standard = "STANDARD",
    Glacier = "GLACIER",
}

const createStorageSchema = createRefinableSchema({
    schema: (context: CreateContractContext) =>
        z.object({
            key: z.string(),
            provider: z.enum(EStorageProvider),
            bucket: z.string(),
            class: z.enum(EStorageClass),
            name: z.string(),
            contentLength: z.number(),
            contentType: z.string().regex(/^[\w.-]+\/[\w.+-]+$/),
            uploadDate: z.coerce.date(),
            hidden: z.boolean(),
            downloadUrl: z.string().optional(),
            deleted: z.boolean(),
        }),
});

interface IStorage extends InferSchemaFromRefinableSchema<typeof createStorageSchema> {}

enum EStorageImageType {
    Gif = "gif",
    Jpeg = "jpeg",
    Png = "png",
    Svg = "svg",
    Webp = "webp",
}

const STORAGE_FILE_TYPES_IMAGE = [
    EStorageImageType.Gif,
    EStorageImageType.Jpeg,
    EStorageImageType.Png,
    EStorageImageType.Webp,
    EStorageImageType.Svg,
];
Object.freeze(STORAGE_FILE_TYPES_IMAGE);

type StorageColumn = keyof IStorage;

export {
    createStorageSchema,
    EStorageClass,
    EStorageImageType,
    EStorageProvider,
    type IStorage,
    STORAGE_FILE_TYPES_IMAGE,
    type StorageColumn,
};
