type Modify<Type, Replace = any> = Omit<Type, keyof Replace> & Replace;

type DeeplySearchAndReplace<T, Search, Replace> =
    // 1. Direct match (distributive on unions)
    T extends Search
        ? Replace
        : // 2. Tuples (and readonly tuples)
          T extends readonly [any, ...any[]]
          ? { [K in keyof T]: DeeplySearchAndReplace<T[K], Search, Replace> }
          : // 3. Arrays
            T extends (infer U)[]
            ? DeeplySearchAndReplace<U, Search, Replace>[]
            : // 4. Leave functions as-is
              T extends (...args: any[]) => any
              ? T
              : // 5. Objects: recurse into properties
                T extends object
                ? { [K in keyof T]: DeeplySearchAndReplace<T[K], Search, Replace> }
                : // 6. Primitives and others
                  T;

export { type Modify, type DeeplySearchAndReplace };
