type TRequestContentType = "application/json" | "multipart/form-data";
type TRequestLanguage = "de" | "en";

enum EHttpStatusCodeSuccess {
    OK = 200,
    Created = 201,
    Accepted = 202,
    NoContent = 204,
}

enum EHttpStatusCodeClientError {
    BadRequest = 400,
    Unauthorized = 401,
    Forbidden = 403,
    NotFound = 404,
    Gone = 410,
    ImATeapotTrolling = 418,
    UnprocessableEntity = 422,
    TooManyRequests = 429,
}

enum EHttpStatusCodeServerError {
    InternalServerError = 500,
    ServiceUnavailable = 503,
    GatewayTimeout = 504,
}

enum ERequestError {
    NetworkError = "networkError",
    BadRequest = "badRequest",
    UnprocessableEntity = "unprocessableEntity",
    Unauthorized = "unauthorized",
    Forbidden = "forbidden",
    NotFound = "notFound",
    InternalServerError = "internalServerError",
    ServiceUnavailable = "serviceUnavailable",
    GatewayTimeout = "gatewayTimeout",
    Unknown = "unknown",
}

export {
    EHttpStatusCodeSuccess,
    EHttpStatusCodeClientError,
    EHttpStatusCodeServerError,
    ERequestError,
    type TRequestContentType,
    type TRequestLanguage,
};
