import type { ERouteHttpVerb } from "./http-verb.js";

/**
 * Extracted from official DT as it cannot be extracted (default generics are not extractable).
 *
 * @see https://github.com/DefinitelyTyped/DefinitelyTyped/blob/ea4d4e50e11788ef0a8094d7de564ad2f01dfedd/types/express-serve-static-core/index.d.ts#L52
 */
interface ParamsDictionary {
    [key: string]: string;
}

/**
 * @deprecated Directly use `createContract` instead
 */
interface IRouteLocationInterface {
    path: string;
    method: ERouteHttpVerb;
}

/**
 * @deprecated Use zod schema instead
 */
interface IRouteRequestInterface {}

interface IRouteParamsInterface extends ParamsDictionary {
    [key: string]: any;
}

/**
 * @deprecated Use type definition and entity interfaces instead
 */
interface IRouteResponseInterface {}

/** Optional usable cursor fields. Be sure to use both, cursor and limit. */
interface IRouteParamsCursorInterface {
    cursor: string;
    limit: number;
}

/** Optional usable cursor response Metadata. */
interface IRouteResponseCursorMetaDataInterface {
    responseMetadata: {
        cursor?: string;
        nextCursor?: string;
        dataCount?: number;
    };
}

type RemoveRouteAnyKey<T> = {
    // eslint-disable-next-line @typescript-eslint/no-unused-vars -- hacky way for "not any"
    [Key in keyof T as Key extends `${infer R}` ? Key : never]: T[Key];
};

export {
    type ParamsDictionary,
    type IRouteLocationInterface,
    type IRouteRequestInterface,
    type IRouteParamsInterface,
    type IRouteResponseInterface,
    type IRouteParamsCursorInterface,
    type IRouteResponseCursorMetaDataInterface,
    type RemoveRouteAnyKey,
};
