import { createCommand } from "commander";

import { ossExtractExecute } from "./execute.js";

import type { Command } from "commander";

type OssExtractOpts = Record<string, never>;

function ossExtractCommand(): Command {
    return createCommand("oss-extract")
        .description(
            "Define a set of whitelist rules which will be used to extract the OSS content from the monorepo. This allows publishing OSS packages to e.g. a public GitHub repository.",
        )
        .action((args: OssExtractOpts) => {
            ossExtractExecute(args);
        });
}

export { type OssExtractOpts, ossExtractCommand };
