import { createCommand } from "commander";

import { pnpmWorkspaceUpdateExecute } from "./execute.js";

import type { Command } from "commander";

type PnpmWorkspaceUpdateOpts = {
    catalog: string;
    nodeVersion: string;
};

function pnpmWorkspaceUpdateCommand(): Command {
    return createCommand("pnpm-workspace-update")
        .description(
            "Update the pnpm-workspace.yaml file to the latest version and also check versions which are ESM only.",
        )
        .option("-c, --catalog <catalog>", "The catalog to update.", "frontend")
        .option(
            "-n, --node-version <nodeVersion>",
            "The node version to check compatibility with.",
            process.version.replace(/^v/, ""),
        )
        .action((args: PnpmWorkspaceUpdateOpts) => {
            pnpmWorkspaceUpdateExecute(args);
        });
}

export { type PnpmWorkspaceUpdateOpts, pnpmWorkspaceUpdateCommand };
