import { readFileSync } from "node:fs";

function getPackageName(cwd: string, removePackageScope = false, convertToSnakeCase = false) {
    // eslint-disable-next-line n/no-sync
    const packageJson = JSON.parse(readFileSync(`${cwd}/package.json`).toString());
    const fullName = packageJson.name;

    let finalName: string;

    if (removePackageScope) {
        [, finalName] = fullName.split("/");
    } else {
        finalName = fullName;
    }

    if (convertToSnakeCase) {
        finalName = finalName.replace(/-/g, "_");
    }

    return finalName;
}

export { getPackageName };
