import type { I18nRow } from "../types/types.js";

abstract class AbstractOutputFormat {
    protected items: string[] = [];

    public output(): { added: number; output: string } {
        return {
            output: this.items.join("\n"),
            added: this.items.length,
        };
    }

    public abstract add(row: I18nRow): void;
}

export { AbstractOutputFormat };
