import { format } from "node:util";

//const EXTRACT_I18N_RELEVANT_CONTENT_FROM_SOURCE =
// /(?:\(\d+,[A-Za-z_-]+__WEBPACK_IMPORTED_MODULE_\d+__\.(?<functionName>__|_x|_n|_nx)\)\s*\((?<functionArguments>(?:(["']?)[^\3]*?\3)(?:[,]?\s*(["']?)[^\4]*?\4)(?:[,]?\s*(["']?)[^\5]*?\5))|(?<multilineComment>\/\*[^*]*\*+(?:[^/*][^*]*\*+)*\/)|(?<singlelineComment>\/\/\s*translator[^\n]+))/gis;

const FUNCTION_ARGUMENTS = `(?<functionArguments>(?:(["'\`]?)[^\\3]*?\\3)(?:[,]?\\s*(["'\`]?)[^\\4]*?\\4)(?:[,]?\\s*(["'\`]?)[^\\5]*?\\5))`;
const MULTI_LINE_COMMENTS = `(?<multilineComment>\\/\\*[^*]*\\*+(?:[^/*][^*]*\\*+)*\\/)`;
const SINGLE_LINE_COMMENTS = `(?<singlelineComment>\\/\\/\\s*translator[^\\n]+)`;

/**
 * This regular expression does currently not support exclusion of non-translator
 * multiline comments and escaped quotes inside the function arguments. For this, we need to do
 * a simple search&replace for quotes and reverse it, and an additional check for
 * translator-comment.
 *
 * @see https://regex101.com/r/MRjs2h/7
 */
function createI18nRegexp({
    beforeFunctionNameRegexp,
    afterFunctionNameRegexp,
    functionNames,
}: {
    beforeFunctionNameRegexp?: string;
    afterFunctionNameRegexp?: string;
    functionNames?: string[];
} = {}) {
    return new RegExp(
        format(
            `(?:%s(?<functionName>%s)%s\\s*\\(%s|%s|%s)`,
            beforeFunctionNameRegexp,
            functionNames.join("|"),
            afterFunctionNameRegexp,
            FUNCTION_ARGUMENTS,
            MULTI_LINE_COMMENTS,
            SINGLE_LINE_COMMENTS,
        ),
        "gis",
    );
}

export { createI18nRegexp };
