/**
 * Extract matches from file content via regular expression.
 */
type ExtractI18nRelevantContentFromSourceGroups =
    | {
          type: "functionCall";
          functionArguments: string;
          functionName: string;
          originalMatch: RegExpExecArray;
      }
    | {
          type: "multilineComment";
          multilineComment: string;
      }
    | {
          type: "singlelineComment";
          singlelineComment: string;
      };

type ExtractI18nRowTypes = "single" | "singleContext" | "plural" | "pluralContext";

/**
 * Converted relevant code to a more "common" map with comments
 * related to a translation.
 */
type ExtractI18nRow = {
    comments: string[];
    type: ExtractI18nRowTypes;
    args: string[];
    originalMatch?: RegExpExecArray;
};

/**
 * Common properties for I18nRow.
 */
type I18nRowCommonProperties = {
    occurences: string;
    comments: ExtractI18nRow["comments"];
};

// An I18nRow describes a full translation and already got validated
type I18nRow =
    | ({
          type: "single";
          single: string;
      } & I18nRowCommonProperties)
    | ({
          type: "singleContext";
          single: string;
          context: string;
      } & I18nRowCommonProperties)
    | ({
          type: "plural";
          single: string;
          plural: string;
      } & I18nRowCommonProperties)
    | ({
          type: "pluralContext";
          single: string;
          plural: string;
          context: string;
      } & I18nRowCommonProperties);

export {
    type ExtractI18nRelevantContentFromSourceGroups,
    type ExtractI18nRowTypes,
    type ExtractI18nRow,
    type I18nRowCommonProperties,
    type I18nRow,
};
