/**
 * Provide `process.env.PLUGIN_CTX` to your script. Do not forget to add the
 * following snippet to your entry point so the prefix is correctly taken:
 *
 * ```ts
 * // Configure prefix for root (https://bit.ly/3wb2pv9)
 * ConfigProvider.config({
 *    prefixCls: process.env.ANTD_PREFIX
 * });
 *
 * // or
 * <ConfigProvider prefixCls={process.env.ANTD_PREFIX}></ConfigProvider>
 * ```
 *
 * @param pluginContext
 * @param processEnv
 */
function applyAntdDefinePlugin(prefix: string, processEnv: any) {
    processEnv.ANTD_PREFIX = JSON.stringify(prefix);
}

export { applyAntdDefinePlugin };
