/**
 * Convert a slug like "my-plugin" to "myPlugin". This can
 * be useful for library naming (window[""] is bad because the hyphens).
 *
 * @param slug
 * @returns
 */
function slugCamelCase(slug: string) {
    return slug.replace(/-([a-z])/g, (g) => g[1].toUpperCase());
}

export { slugCamelCase };
