import { consent } from "./consent.js";

import type { OmitFirst } from "../types/types.js";

type P = Parameters<typeof consent>;

/**
 * `window.consentApi.consentAll`: Check if a set of given technical information (e.g. HTTP Cookie, LocalStorage, ...)
 * have a consent. This is similar to `window.consentApi.consent` but for multiple cookies.
 */
function consentAll(options: P[0], technicalDefinitions: OmitFirst<P>[]) {
    return Promise.all(technicalDefinitions.map((args) => consent(options, ...args)));
}

export { consentAll };
